/*
 * Decompiled with CFR 0.152.
 */
package net.pevori.queencats.entity.custom;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.pevori.queencats.entity.ModEntityTypes;
import net.pevori.queencats.entity.custom.HumanoidAnimalEntity;
import net.pevori.queencats.entity.custom.HumanoidCatEntity;
import net.pevori.queencats.entity.custom.PrincessCatEntity;
import net.pevori.queencats.entity.variants.HumanoidCatVariant;
import net.pevori.queencats.item.ModItems;
import net.pevori.queencats.sound.ModSounds;

public class QueenCatEntity
extends HumanoidCatEntity {
    public QueenCatEntity(EntityType<? extends HumanoidCatEntity> entityType, Level level) {
        super((EntityType<? extends HumanoidAnimalEntity>)entityType, level);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 8.0f, 3.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.GOLDEN_FISH.get()}), false));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob mob) {
        PrincessCatEntity baby = (PrincessCatEntity)((EntityType)ModEntityTypes.PRINCESS_CAT.get()).m_20615_((Level)serverLevel);
        HumanoidCatVariant variant = (HumanoidCatVariant)((Object)Util.m_214670_((Object[])HumanoidCatVariant.values(), (RandomSource)this.f_19796_));
        baby.setVariant(variant);
        if (this.m_21824_()) {
            baby.m_21828_((Player)this.m_21826_());
            baby.m_21816_(this.m_21805_());
        }
        return baby;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        Item itemForTaming = (Item)ModItems.GOLDEN_FISH.get();
        Ingredient itemForHealing = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42528_, (ItemLike)ModItems.GOLDEN_FISH.get()});
        if (this.m_6898_(itemstack)) {
            return super.m_6071_(player, hand);
        }
        if (item instanceof DyeItem && this.m_21830_((LivingEntity)player) && !player.m_6144_()) {
            DyeColor dyeColor = ((DyeItem)item).m_41089_();
            if (dyeColor == DyeColor.BLACK) {
                this.setVariant(HumanoidCatVariant.BLACK);
            } else if (dyeColor == DyeColor.WHITE) {
                this.setVariant(HumanoidCatVariant.WHITE);
            } else if (dyeColor == DyeColor.ORANGE) {
                this.setVariant(HumanoidCatVariant.CALICO);
            } else if (dyeColor == DyeColor.GRAY) {
                this.setVariant(HumanoidCatVariant.CALLAS);
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        if (itemForHealing.test(itemstack) && this.m_21824_() && this.m_21223_() < this.m_21233_() && !player.m_6144_()) {
            if (this.f_19853_.m_5776_()) {
                return InteractionResult.CONSUME;
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.f_19853_.m_5776_()) {
                this.m_5634_(10.0f);
                if (this.m_21223_() > this.m_21233_()) {
                    this.m_21153_(this.m_21233_());
                }
                this.m_5496_((SoundEvent)ModSounds.HUMANOID_CAT_EAT.get(), 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (item == itemForTaming && !this.m_21824_()) {
            if (this.f_19853_.m_5776_()) {
                return InteractionResult.CONSUME;
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.f_19853_.m_5776_()) {
                this.m_5496_((SoundEvent)ModSounds.HUMANOID_CAT_EAT.get(), 1.0f, 1.0f);
                super.m_21828_(player);
                this.f_21344_.m_26569_();
                this.m_6710_(null);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
                this.setSitting(true);
                this.m_21153_(this.m_21233_());
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && !player.m_6144_() && !this.f_19853_.m_5776_() && hand == InteractionHand.MAIN_HAND) {
            this.setSitting(!this.isSitting());
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == itemForTaming) {
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(60.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(5.0);
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.3f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.3f);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        HumanoidCatVariant variant = (HumanoidCatVariant)((Object)Util.m_214670_((Object[])HumanoidCatVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }
}

